<?php
require_once 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    sendResponse('error', 'Non autorisé');
}

$userId = $_SESSION['user_id'];

// Handle file upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['document'])) {
    $documentType = $_POST['document_type'] ?? ''; // id_document, proof_address, proof_income_1, etc.
    
    if (!in_array($documentType, ['id_document', 'proof_address', 'proof_income_1', 'proof_income_2', 'proof_income_3'])) {
        sendResponse('error', 'Type de document invalide');
    }

    $file = $_FILES['document'];
    $allowedTypes = ['image/jpeg', 'image/png', 'image/jpg', 'application/pdf'];
    $maxSize = 5 * 1024 * 1024; // 5MB

    // Validation
    if ($file['error'] !== UPLOAD_ERR_OK) {
        sendResponse('error', 'Erreur lors du téléchargement');
    }

    if (!in_array($file['type'], $allowedTypes)) {
        sendResponse('error', 'Type de fichier non autorisé. Utilisez JPG, PNG ou PDF');
    }

    if ($file['size'] > $maxSize) {
        sendResponse('error', 'Fichier trop volumineux (max 5MB)');
    }

    try {
        // Create uploads directory if it doesn't exist
        $uploadDir = __DIR__ . '/uploads/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }

        // Generate unique filename
        $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
        $filename = $userId . '_' . $documentType . '_' . time() . '.' . $extension;
        $filepath = $uploadDir . $filename;

        // Move uploaded file
        if (!move_uploaded_file($file['tmp_name'], $filepath)) {
            sendResponse('error', 'Erreur lors de la sauvegarde du fichier');
        }

        // Update database
        $columnName = $documentType . '_path';
        $stmt = $pdo->prepare("UPDATE users SET $columnName = ? WHERE id = ?");
        $stmt->execute(['uploads/' . $filename, $userId]);

        sendResponse('success', 'Document téléchargé avec succès', [
            'filename' => $filename,
            'path' => 'uploads/' . $filename
        ]);

    } catch (PDOException $e) {
        sendResponse('error', 'Erreur serveur: ' . $e->getMessage());
    }
} else {
    sendResponse('error', 'Aucun fichier reçu');
}
