<?php
require_once 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    sendResponse('error', 'Non autorisé');
}

$userId = $_SESSION['user_id'];
$input = json_decode(file_get_contents('php://input'), true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Update profile
    $firstName = $input['first_name'] ?? '';
    $lastName = $input['last_name'] ?? '';
    $phone = $input['phone'] ?? '';
    $address = $input['address'] ?? '';
    $city = $input['city'] ?? '';
    $zipCode = $input['zip_code'] ?? '';

    try {
        $stmt = $pdo->prepare("
            UPDATE users 
            SET first_name = ?, last_name = ?, phone = ?, address = ?, city = ?, zip_code = ?
            WHERE id = ?
        ");
        $stmt->execute([$firstName, $lastName, $phone, $address, $city, $zipCode, $userId]);

        sendResponse('success', 'Profil mis à jour avec succès');
    } catch (PDOException $e) {
        sendResponse('error', 'Erreur lors de la mise à jour: ' . $e->getMessage());
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Get profile (redirect to get-profile.php)
    require_once 'get-profile.php';
} else {
    sendResponse('error', 'Méthode non autorisée');
}
