<?php
require_once 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    sendResponse('error', 'Non autorisé');
}

$userId = $_SESSION['user_id'];
$action = $input['action'] ?? '';

if ($action === 'initiate') {
    $amount = $input['amount'] ?? 0;
    $recipient = $input['recipient'] ?? '';
    $iban = $input['iban'] ?? '';

    if ($amount <= 0 || empty($recipient) || empty($iban)) {
        sendResponse('error', 'Données invalides');
    }

    try {
        // Create transaction
        $stmt = $pdo->prepare("INSERT INTO transactions (user_id, type, amount, description, recipient_name, recipient_iban, progress_percent, is_blocked, status) VALUES (?, 'transfer_out', ?, 'Virement sortant', ?, ?, 0, 1, 'pending')");
        $stmt->execute([$userId, $amount, $recipient, $iban]);
        $transactionId = $pdo->lastInsertId();

        // Get user step config
        $stmtUser = $pdo->prepare("SELECT transfer_step_config FROM users WHERE id = ?");
        $stmtUser->execute([$userId]);
        $userConfig = $stmtUser->fetchColumn();
        
        $steps = [30, 60, 90]; // Default
        if ($userConfig) {
            $steps = json_decode($userConfig, true) ?? [30, 60, 90];
        }

        // Create steps
        foreach ($steps as $stepPercent) {
            $stmtStep = $pdo->prepare("INSERT INTO virement_steps (transaction_id, step_percent, block_reason, unlock_code, status) VALUES (?, ?, ?, ?, 'pending')");
            // Generate a random code for demo purposes, in reality this might be set by admin or fixed
            $code = rand(100000, 999999); 
            $reason = "Vérification de sécurité à {$stepPercent}%";
            $stmtStep->execute([$transactionId, $stepPercent, $reason, $code]);
        }

        // Update transaction to first step
        $firstStep = $steps[0];
        $pdo->prepare("UPDATE transactions SET progress_percent = ?, block_reason = 'Vérification initiale', is_blocked = 1 WHERE id = ?")->execute([$firstStep, $transactionId]);

        sendResponse('success', 'Virement initié', ['transaction_id' => $transactionId]);

    } catch (PDOException $e) {
        sendResponse('error', 'Erreur serveur: ' . $e->getMessage());
    }
} elseif ($action === 'validate') {
    // Validate transfer step
    $transactionId = $input['transaction_id'] ?? 0;
    $code = $input['code'] ?? '';

    if (!$transactionId || !$code) {
        sendResponse('error', 'Données manquantes');
    }

    try {
        // Get the pending step for this transaction
        $stmt = $pdo->prepare("
            SELECT id, step_percent, unlock_code 
            FROM virement_steps 
            WHERE transaction_id = ? AND status = 'pending'
            ORDER BY step_percent ASC
            LIMIT 1
        ");
        $stmt->execute([$transactionId]);
        $step = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$step) {
            sendResponse('error', 'Aucune étape en attente');
        }

        // Verify code
        if ($code !== $step['unlock_code']) {
            sendResponse('error', 'Code invalide');
        }

        // Mark step as completed
        $pdo->prepare("UPDATE virement_steps SET status = 'completed' WHERE id = ?")->execute([$step['id']]);

        // Check if there are more steps
        $stmtNextStep = $pdo->prepare("
            SELECT id, step_percent, block_reason, unlock_code
            FROM virement_steps 
            WHERE transaction_id = ? AND status = 'pending'
            ORDER BY step_percent ASC
            LIMIT 1
        ");
        $stmtNextStep->execute([$transactionId]);
        $nextStep = $stmtNextStep->fetch(PDO::FETCH_ASSOC);

        if ($nextStep) {
            // Update transaction to next step
            $pdo->prepare("
                UPDATE transactions 
                SET progress_percent = ?, block_reason = ?, is_blocked = 1
                WHERE id = ?
            ")->execute([$nextStep['step_percent'], $nextStep['block_reason'], $transactionId]);

            sendResponse('success', 'Code validé, prochaine étape', [
                'next_step' => $nextStep['step_percent'],
                'block_reason' => $nextStep['block_reason']
            ]);
        } else {
            // All steps completed, finalize transfer
            $pdo->prepare("
                UPDATE transactions 
                SET progress_percent = 100, is_blocked = 0, block_reason = NULL
                WHERE id = ?
            ")->execute([$transactionId]);

            // Deduct amount from user balance
            $stmtTrans = $pdo->prepare("SELECT amount, user_id FROM transactions WHERE id = ?");
            $stmtTrans->execute([$transactionId]);
            $trans = $stmtTrans->fetch(PDO::FETCH_ASSOC);

            $pdo->prepare("UPDATE users SET balance = balance - ? WHERE id = ?")->execute([$trans['amount'], $trans['user_id']]);

            sendResponse('success', 'Virement complété avec succès', ['completed' => true]);
        }

    } catch (PDOException $e) {
        sendResponse('error', 'Erreur serveur: ' . $e->getMessage());
    }
} else {
    sendResponse('error', 'Action invalide');
}
