<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse('error', 'Method not allowed');
}

// Determine if it's a JSON request or Form Data
$contentType = $_SERVER['CONTENT_TYPE'] ?? '';
$isJson = strpos($contentType, 'application/json') !== false;

if ($isJson) {
    $input = json_decode(file_get_contents('php://input'), true);
} else {
    $input = $_POST;
}

$action = $input['action'] ?? '';

if ($action === 'check_email') {
    $email = $input['email'] ?? '';
    if (empty($email)) {
        sendResponse('error', 'L\'adresse e-mail est obligatoire.');
    }
    
    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$email]);
    if ($stmt->fetch()) {
        sendResponse('error', 'Cette adresse e-mail est déjà utilisée.');
    } else {
        sendResponse('success', 'Email disponible');
    }
}

if ($action === 'register') {
    // Basic fields
    $firstName = $input['first_name'] ?? '';
    $lastName = $input['last_name'] ?? '';
    $email = $input['email'] ?? '';
    $phone = $input['phone'] ?? '';
    $dob = $input['date_of_birth'] ?? '';
    $password = $input['password'] ?? '';
    
    // Extended fields
    $address = $input['address'] ?? '';
    $city = $input['city'] ?? '';
    $zipCode = $input['zip_code'] ?? '';
    $profSituation = $input['professional_situation'] ?? '';
    $income = $input['net_monthly_income'] ?? '';

    if (empty($firstName) || empty($lastName) || empty($email) || empty($password) || empty($dob) || empty($address) || empty($city) || empty($zipCode) || empty($profSituation) || empty($income)) {
        sendResponse('error', 'Veuillez remplir tous les champs obligatoires.');
    }

    // Final check for email
    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$email]);
    if ($stmt->fetch()) {
        sendResponse('error', 'Cette adresse e-mail est déjà utilisée.');
    }

    // Handle File Uploads
    $uploadDir = __DIR__ . '/uploads/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $filePaths = [
        'id_document' => '',
        'proof_address' => '',
        'proof_income_1' => '',
        'proof_income_2' => '',
        'proof_income_3' => ''
    ];

    foreach ($filePaths as $key => &$path) {
        if (isset($_FILES[$key]) && $_FILES[$key]['error'] === UPLOAD_ERR_OK) {
            $tmpName = $_FILES[$key]['tmp_name'];
            $name = basename($_FILES[$key]['name']);
            $ext = pathinfo($name, PATHINFO_EXTENSION);
            $uniqueName = uniqid($key . '_') . '.' . $ext;
            $destination = $uploadDir . $uniqueName;

            if (move_uploaded_file($tmpName, $destination)) {
                $path = 'uploads/' . $uniqueName;
            } else {
                sendResponse('error', "Erreur lors du téléchargement du fichier $key.");
            }
        } else {
             // For required files, you might want to enforce this. 
             // Assuming all are required based on the form.
             sendResponse('error', "Le fichier $key est manquant ou invalide.");
        }
    }

    try {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        $account_number = 'BSN' . rand(10000000, 99999999);
        
        $sql = "INSERT INTO users (
            first_name, last_name, email, phone, date_of_birth, 
            address, city, zip_code, professional_situation, net_monthly_income,
            id_document_path, proof_address_path, proof_income_1_path, proof_income_2_path, proof_income_3_path,
            password, account_number
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $firstName, $lastName, $email, $phone, $dob,
            $address, $city, $zipCode, $profSituation, $income,
            $filePaths['id_document'], $filePaths['proof_address'], 
            $filePaths['proof_income_1'], $filePaths['proof_income_2'], $filePaths['proof_income_3'],
            $hashed_password, $account_number
        ]);
        
        $userId = $pdo->lastInsertId();

        // Handle Simulation Data
        $simAmount = $input['simulation_amount'] ?? null;
        $simDuration = $input['simulation_duration'] ?? null;
        $simApr = $input['simulation_apr'] ?? null;
        $simMonthly = $input['simulation_monthly'] ?? null;

        if ($simAmount && $simDuration && $simApr && $simMonthly) {
            $stmtLoan = $pdo->prepare("INSERT INTO loan_applications (user_id, amount, duration, apr, monthly_payment) VALUES (?, ?, ?, ?, ?)");
            $stmtLoan->execute([$userId, $simAmount, $simDuration, $simApr, $simMonthly]);
        }

        // Send Email via Centralized Mail Service
        require_once 'mail.php';

        $emailBody = "
            <h1>Bienvenue $firstName !</h1>
            <p>Votre compte a été créé avec succès.</p>
            <p>Votre numéro de compte client est : <strong>$account_number</strong></p>
        ";

        if ($simAmount) {
            $emailBody .= "
                <h2>Récapitulatif de votre demande de crédit</h2>
                <ul>
                    <li>Montant demandé : <strong>" . number_format($simAmount, 2, ',', ' ') . " €</strong></li>
                    <li>Durée : <strong>$simDuration mois</strong></li>
                    <li>Mensualité estimée : <strong>" . number_format($simMonthly, 2, ',', ' ') . " €</strong></li>
                    <li>TAEG : <strong>$simApr %</strong></li>
                </ul>
                <p>Votre demande est en cours d'analyse. Un conseiller reviendra vers vous sous 24h.</p>
            ";
        }

        $emailBody .= "<p>Merci de votre confiance,<br>L'équipe BSN FINANCEMENT</p>";

        sendMail($email, "$firstName $lastName", 'Bienvenue chez BSN FINANCEMENT - Confirmation de compte', $emailBody);
        
        sendResponse('success', 'Votre compte a été créé avec succès ! Vous pouvez maintenant vous connecter.');
    } catch (PDOException $e) {
        sendResponse('error', 'Une erreur est survenue lors de la création de votre compte: ' . $e->getMessage());
    }
}

sendResponse('error', 'Action non valide');
