<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

// Load Composer's autoloader
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    require __DIR__ . '/vendor/autoload.php';
} elseif (file_exists(__DIR__ . '/PHPMailer/src/Exception.php')) {
    // Fallback to manual load
    require_once __DIR__ . '/PHPMailer/src/Exception.php';
    require_once __DIR__ . '/PHPMailer/src/PHPMailer.php';
    require_once __DIR__ . '/PHPMailer/src/SMTP.php';
}

function sendMail($to, $toName, $subject, $body) {
    // SMTP Configuration
    $smtpHost = 'server374.web-hosting.com'; // Replace with your SMTP host
    $smtpUsername = 'contact@bsnfinancement.com'; // Replace with your SMTP username
    $smtpPassword = 'Contact@2025'; // Replace with your SMTP password
    $smtpPort = 465;
    $smtpSecure = 'ssl'; // or 'tls'

    // If PHPMailer class doesn't exist (library not found), fallback to mail() or return error
    if (!class_exists('PHPMailer\PHPMailer\PHPMailer')) {
        error_log("PHPMailer library not found. Using native mail() as fallback.");
        // Fallback to native mail()
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= 'From: BSN FINANCEMENT <contact@bsnfinancement.com>' . "\r\n";
        return mail($to, $subject, $body, $headers);
    }

    $mail = new PHPMailer(true);

    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host       = $smtpHost;
        $mail->SMTPAuth   = true;
        $mail->Username   = $smtpUsername;
        $mail->Password   = $smtpPassword;
        $mail->SMTPSecure = $smtpSecure === 'ssl' ? PHPMailer::ENCRYPTION_SMTPS : PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = $smtpPort;
        $mail->CharSet    = 'UTF-8';

        // Recipients
        $mail->setFrom('contact@bsnfinancement.com', 'BSN FINANCEMENT');
        $mail->addAddress($to, $toName);

        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $body;

        $mail->send();
        return true;
    } catch (Exception $e) {
        error_log("Message could not be sent. Mailer Error: {$mail->ErrorInfo}");
        return false;
    }
}
