<?php
require_once 'config.php';



if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse('error', 'Method not allowed');
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);
$email = $input['email'] ?? '';
$password = $input['password'] ?? '';

if (empty($email) || empty($password)) {
    sendResponse('error', 'Por favor, rellene todos los campos.');
}

try {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        // Login success
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_name'] = $user['first_name'] . ' ' . $user['last_name'];
        
        sendResponse('success', 'Inicio de sesión exitoso', [
            'user' => [
                'id' => $user['id'],
                'name' => $_SESSION['user_name'],
                'email' => $user['email']
            ],
            'redirect' => '/dashboard/'
        ]);
    } else {
        sendResponse('error', 'Credenciales inválidas.');
    }
} catch (PDOException $e) {
    sendResponse('error', 'Error del servidor: ' . $e->getMessage());
}

