<?php
require_once 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    sendResponse('error', 'Non autorisé');
}

$userId = $_SESSION['user_id'];

try {
    // Get all transactions for the user
    $stmt = $pdo->prepare("
        SELECT 
            id, type, amount, description, recipient_name, recipient_iban,
            progress_percent, is_blocked, block_reason, created_at
        FROM transactions 
        WHERE user_id = ?
        ORDER BY created_at DESC
        LIMIT 50
    ");
    $stmt->execute([$userId]);
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    sendResponse('success', 'Transactions récupérées', ['transactions' => $transactions]);

} catch (PDOException $e) {
    sendResponse('error', 'Erreur serveur: ' . $e->getMessage());
}
