<?php
require_once 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    sendResponse('error', 'Non autorisé');
}

$userId = $_SESSION['user_id'];

try {
    // Get user profile with all details
    $stmt = $pdo->prepare("
        SELECT 
            id, first_name, last_name, email, phone, date_of_birth,
            address, city, zip_code, professional_situation, net_monthly_income,
            id_document_path, proof_address_path, 
            proof_income_1_path, proof_income_2_path, proof_income_3_path,
            account_number, balance, status, transfer_step_config, created_at
        FROM users 
        WHERE id = ?
    ");
    $stmt->execute([$userId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        sendResponse('error', 'Utilisateur non trouvé');
    }

    // Parse transfer step config
    if ($user['transfer_step_config']) {
        $user['transfer_step_config'] = json_decode($user['transfer_step_config'], true);
    } else {
        $user['transfer_step_config'] = [30, 60, 90]; // Default
    }

    // Remove sensitive data
    unset($user['password']);

    sendResponse('success', 'Profil récupéré', ['user' => $user]);

} catch (PDOException $e) {
    sendResponse('error', 'Erreur serveur: ' . $e->getMessage());
}
