<?php
require_once 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    sendResponse('error', 'Non autorisé');
}

$userId = $_SESSION['user_id'];

try {
    // Get all loan applications for the user
    $stmt = $pdo->prepare("
        SELECT 
            id, amount, duration, apr, monthly_payment, status, created_at
        FROM loan_applications 
        WHERE user_id = ?
        ORDER BY created_at DESC
    ");
    $stmt->execute([$userId]);
    $loans = $stmt->fetchAll(PDO::FETCH_ASSOC);

    sendResponse('success', 'Prêts récupérés', ['loans' => $loans]);

} catch (PDOException $e) {
    sendResponse('error', 'Erreur serveur: ' . $e->getMessage());
}
