<?php
require_once 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    sendResponse('error', 'Non autorisé');
}

$userId = $_SESSION['user_id'];

try {
    // Check for active (blocked) transfers
    $stmt = $pdo->prepare("
        SELECT 
            t.id, t.amount, t.recipient_name, t.recipient_iban, t.description,
            t.progress_percent, t.is_blocked, t.block_reason, t.created_at,
            vs.id as step_id, vs.step_percent, vs.block_reason as step_block_reason,
            vs.unlock_code, vs.status as step_status
        FROM transactions t
        LEFT JOIN virement_steps vs ON t.id = vs.transaction_id AND vs.status = 'pending'
        WHERE t.user_id = ? 
        AND t.type = 'transfer_out'
        AND t.is_blocked = 1
        ORDER BY t.created_at DESC
        LIMIT 1
    ");
    $stmt->execute([$userId]);
    $activeTransfer = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($activeTransfer) {
        sendResponse('success', 'Virement actif trouvé', ['transfer' => $activeTransfer]);
    } else {
        sendResponse('success', 'Aucun virement actif', ['transfer' => null]);
    }

} catch (PDOException $e) {
    sendResponse('error', 'Erreur serveur: ' . $e->getMessage());
}
