<?php
require_once 'config.php';



if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse('error', 'Method not allowed');
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

$name = $input['name'] ?? '';
$email = $input['email'] ?? '';
$subject = $input['subject'] ?? '';
$message = $input['message'] ?? '';

if (empty($name) || empty($email) || empty($message)) {
    sendResponse('error', 'Por favor, rellene todos los campos obligatorios.');
}

try {
    $stmt = $pdo->prepare("INSERT INTO contact_messages (name, email, subject, message) VALUES (?, ?, ?, ?)");
    $stmt->execute([$name, $email, $subject, $message]);

    // Send Email via Centralized Mail Service
    require_once 'mail.php';
    
    // Email to Admin
    $adminBody = "
        <h2>Nouveau message de contact</h2>
        <p><strong>Nom:</strong> $name</p>
        <p><strong>Email:</strong> $email</p>
        <p><strong>Sujet:</strong> $subject</p>
        <p><strong>Message:</strong><br>$message</p>
    ";
    sendMail('contact@bsn-financement.com', 'Admin', "Nouveau message de $name", $adminBody);

    // Confirmation Email to User
    $userBody = "
        <h2>Bonjour $name,</h2>
        <p>Nous avons bien reçu votre message et nous vous en remercions.</p>
        <p>Notre équipe vous répondra dans les plus brefs délais.</p>
        <p>Cordialement,<br>L'équipe BSN FINANCEMENT</p>
    ";
    sendMail($email, $name, 'Confirmation de réception de votre message', $userBody);
    
    sendResponse('success', 'Su mensaje ha sido enviado con éxito. Le responderemos lo antes posible.');
} catch (PDOException $e) {
    sendResponse('error', 'Se produjo un error al enviar su mensaje.');
}

